/*
 * Decompiled with CFR 0.152.
 */
package com.sprhibrad.framework.configuration;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.stereotype.Component;

@Component
public class ShrAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    public ShrAuthenticationFailureHandler() {
        this.setDefaultFailureUrl("/login?error");
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        if (exception instanceof InternalAuthenticationServiceException && ((InternalAuthenticationServiceException)exception).getCause() instanceof CannotGetJdbcConnectionException) {
            this.getRedirectStrategy().sendRedirect(request, response, "/login?unavailable");
        } else {
            super.onAuthenticationFailure(request, response, exception);
        }
    }
}

