/*
 * Decompiled with CFR 0.152.
 */
package com.sprhibrad.framework.dao;

import com.sprhibrad.framework.common.DataSetClauses;
import com.sprhibrad.framework.common.ShrImage;
import com.sprhibrad.framework.common.Utils;
import com.sprhibrad.framework.configuration.UserManager;
import com.sprhibrad.framework.dao.IShrDao;
import com.sprhibrad.framework.model.ShrEntity;
import com.sprhibrad.framework.model.VerboseLiteral;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.crypto.password.PasswordEncoder;

public class ShrDao<T extends ShrEntity>
implements IShrDao<T> {
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    UserManager userManager;

    @Override
    public List<T> getObjects(Integer iteration, DataSetClauses clauses, Integer pageSize) {
        CriteriaTools tools = this.getCriteriaQueryTools();
        this.prepareList(tools, clauses);
        return this.presentationList(tools, clauses, iteration, pageSize);
    }

    @Override
    public T getObject(Serializable id) {
        return (T)((ShrEntity)this.getCurrentSession().get(Utils.typeArgumentClass(this.getClass(), 0), id));
    }

    @Override
    public void addObject(T entity) {
        this.manageObject(entity, false);
    }

    @Override
    public void updateObject(T entity) {
        this.manageObject(entity, true);
    }

    protected void manageObject(T object, boolean update) {
        boolean userOp = this.userOperation(object);
        Object objectInDb = null;
        if (update) {
            objectInDb = this.getObject(object.getId());
        }
        String clearPwd = null;
        if (userOp) {
            if (update) {
                this.dropUser(objectInDb);
            }
            clearPwd = this.userManager.getPassword(object);
            this.userManager.setPassword(object, this.passwordEncoder.encode((CharSequence)clearPwd));
        }
        if (update) {
            this.update(object, objectInDb);
            this.getCurrentSession().save(objectInDb);
        } else {
            this.getCurrentSession().save(object);
        }
        if (userOp) {
            this.createUser(this.userManager.getUsername(object), clearPwd);
        }
    }

    @Override
    public void deleteObject(Serializable id) {
        Object entity = this.getObject(id);
        if (entity != null) {
            this.getCurrentSession().delete(entity);
            if (this.userOperation(entity)) {
                this.dropUser(entity);
            }
        }
    }

    @Override
    public void uploadBinary(byte[] bytes, String op, String pp, Serializable id) {
        Object objectInDb = this.getObject(id);
        Utils.setValue(op, (ShrEntity)objectInDb, bytes);
        if (pp.length() > 0) {
            Utils.setValue(pp, (ShrEntity)objectInDb, this.getPreviewBytes(bytes, op));
        }
        this.getCurrentSession().save(objectInDb);
    }

    @Override
    public void deleteBinary(String op, String pp, Serializable id) {
        Object objectInDb = this.getObject(id);
        Utils.setValue(op, (ShrEntity)objectInDb, null);
        if (pp.length() > 0) {
            Utils.setValue(pp, (ShrEntity)objectInDb, null);
        }
        this.getCurrentSession().save(objectInDb);
    }

    protected void update(T object, T objectInDb) {
    }

    protected void prepareList(CriteriaTools tools, DataSetClauses clauses) {
        Object comparingValue = null;
        if (clauses != null) {
            ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
            Predicate predicate = null;
            for (Map.Entry<String, DataSetClauses.Criterion> entry : clauses.filter.entrySet()) {
                String field = entry.getKey();
                DataSetClauses.Criterion criterion = entry.getValue();
                comparingValue = criterion.value;
                Predicate predicate2 = criterion.operator == null || criterion.operator.compareTo("") == 0 ? this.predEQ(tools, field, comparingValue) : (criterion.operator.compareTo(">") == 0 ? this.predGT(tools, field, comparingValue) : (criterion.operator.compareTo("<") == 0 ? this.predLT(tools, field, comparingValue) : (predicate = criterion.operator.compareTo("N") == 0 ? this.predNull(tools, field, comparingValue) : this.predNotNull(tools, field, comparingValue))));
                if (predicate == null) continue;
                predicateList.add(predicate);
            }
            Predicate[] predicates = new Predicate[predicateList.size()];
            int index = 0;
            Iterator iterator = predicateList.iterator();
            while (iterator.hasNext()) {
                Predicate pred;
                predicates[index] = pred = (Predicate)iterator.next();
                ++index;
            }
            tools.criteria.where(predicates);
        }
    }

    protected Session getCurrentSession() {
        return this.sessionFactory.getCurrentSession();
    }

    protected Predicate predEQ(CriteriaTools tools, String field, Object value) {
        CriteriaBuilder builder = tools.builder;
        Root from = tools.from;
        if (value instanceof String) {
            String text = (String)value;
            return text.compareToIgnoreCase("%") == 0 ? null : builder.like((Expression)from.get(field), (String)value);
        }
        if (value instanceof Date) {
            return builder.equal((Expression)from.get(field), (Object)((Date)value));
        }
        if (value instanceof Number) {
            return builder.equal((Expression)from.get(field), (Object)((Number)value));
        }
        return builder.equal((Expression)from.get(field), value);
    }

    protected Predicate predGT(CriteriaTools tools, String field, Object value) {
        CriteriaBuilder builder = tools.builder;
        Root from = tools.from;
        if (value instanceof String) {
            return builder.greaterThan((Expression)from.get(field), (Comparable)((Object)((String)value)));
        }
        if (value instanceof Date) {
            return builder.greaterThan((Expression)from.get(field), (Comparable)((Date)value));
        }
        if (value instanceof VerboseLiteral) {
            Join join = from.join(field, JoinType.INNER);
            VerboseLiteral lCollection = (VerboseLiteral)value;
            return builder.greaterThan((Expression)join.get(lCollection.literalField()), (Comparable)((Object)lCollection.getLiteral()));
        }
        return builder.gt((Expression)from.get(field), (Number)value);
    }

    protected Predicate predLT(CriteriaTools tools, String field, Object value) {
        CriteriaBuilder builder = tools.builder;
        Root from = tools.from;
        if (value instanceof String) {
            return builder.lessThan((Expression)from.get(field), (Comparable)((Object)((String)value)));
        }
        if (value instanceof Date) {
            return builder.lessThan((Expression)from.get(field), (Comparable)((Date)value));
        }
        if (value instanceof VerboseLiteral) {
            Join join = from.join(field, JoinType.INNER);
            VerboseLiteral lCollection = (VerboseLiteral)value;
            return builder.lessThan((Expression)join.get(lCollection.literalField()), (Comparable)((Object)lCollection.getLiteral()));
        }
        return builder.lt((Expression)from.get(field), (Number)value);
    }

    protected Predicate predNull(CriteriaTools tools, String field, Object value) {
        CriteriaBuilder builder = tools.builder;
        Root from = tools.from;
        return builder.isNull((Expression)from.get(field));
    }

    protected Predicate predNotNull(CriteriaTools tools, String field, Object value) {
        CriteriaBuilder builder = tools.builder;
        Root from = tools.from;
        return builder.isNotNull((Expression)from.get(field));
    }

    protected List<T> presentationList(CriteriaTools tools, DataSetClauses clauses, Integer iteration, Integer pageSize) {
        if (clauses != null) {
            this.setOrders(tools, clauses);
        }
        Query query = tools.session.createQuery(tools.criteria);
        if (iteration != null) {
            query.setFirstResult((pageSize == null ? 0 : pageSize) * iteration);
            if (pageSize != null && pageSize > 0) {
                query.setMaxResults(pageSize + 1);
            }
        }
        List returnedList = query.getResultList();
        if (tools.oldIsDefaultReadOnly != null) {
            tools.session.setDefaultReadOnly(tools.oldIsDefaultReadOnly.booleanValue());
        }
        return returnedList;
    }

    protected CriteriaTools getCriteriaQueryTools() {
        Session session = this.getCurrentSession();
        Class cls = Utils.typeArgumentClass(this.getClass(), 0);
        CriteriaTools tools = new CriteriaTools();
        tools.session = session;
        tools.builder = session.getCriteriaBuilder();
        tools.criteria = tools.builder.createQuery(cls);
        tools.from = tools.criteria.from(cls);
        return tools;
    }

    protected void setOrders(CriteriaTools tools, DataSetClauses clauses) {
        Join join;
        Class concreteClass = Utils.typeArgumentClass(this.getClass(), 0);
        Join collector = null;
        collector = clauses.propertyToOrder != null ? (join = tools.from.join(clauses.propertyToOrder, JoinType.INNER)) : tools.from;
        tools.selectRoot();
        Vector<Order> orders = new Vector<Order>();
        if (clauses.order != null) {
            for (DataSetClauses.OrderItem orderItem : clauses.order) {
                orders.add(orderItem.orientation.compareToIgnoreCase("asc") == 0 ? tools.builder.asc((Expression)collector.get(orderItem.field)) : tools.builder.desc((Expression)collector.get(orderItem.field)));
            }
        }
        tools.criteria.orderBy(orders);
    }

    private byte[] getPreviewBytes(byte[] bytes, String rip) {
        BufferedImage image = new ShrImage(bytes, rip, false).getImage();
        Dimension targetDim = new Dimension(image.getWidth(), image.getHeight());
        Utils.insideResize(new Dimension(80, 60), image, targetDim);
        int previewWidth = (int)targetDim.getWidth();
        int previewHeight = (int)targetDim.getHeight();
        BufferedImage previewImage = new BufferedImage(previewWidth, previewHeight, 1);
        Graphics2D g = previewImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.clearRect(0, 0, previewWidth, previewHeight);
        g.drawImage(image, 0, 0, previewWidth, previewHeight, null);
        g.dispose();
        byte[] previewBytes = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)previewImage, "jpg", baos);
            baos.flush();
            previewBytes = baos.toByteArray();
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return previewBytes;
    }

    protected void createUser(String userName, String password) {
        String database = null;
        try {
            database = this.jdbcTemplate.getDataSource().getConnection().getCatalog();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (database != null) {
            this.userManager.createUserDDL(this.jdbcTemplate, database, userName, password);
        }
    }

    protected void dropUser(T entity) {
        this.jdbcTemplate.execute(new ConnectionCallback((ShrEntity)entity){
            private final /* synthetic */ ShrEntity val$entity;
            {
                this.val$entity = shrEntity;
            }

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                Boolean retVal = null;
                try {
                    retVal = con.createStatement().execute(String.format(ShrDao.this.userManager.dropUserDDL(), ShrDao.this.userManager.getUsername(this.val$entity)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return retVal;
            }
        });
    }

    private boolean userOperation(T entity) {
        return Utils.downCaseFirstChar(entity.getClass().getSimpleName()).compareTo(this.userManager.getUserEntityName()) == 0;
    }

    protected class CriteriaTools {
        public Session session;
        public Boolean oldIsDefaultReadOnly;
        public CriteriaBuilder builder;
        public CriteriaQuery<T> criteria;
        public Root<T> from;

        protected CriteriaTools() {
        }

        public void selectRoot() {
            this.criteria.select(this.from);
        }
    }
}

