/*
 * Decompiled with CFR 0.152.
 */
package com.sprhibrad.framework.tags;

import com.sprhibrad.framework.common.ShrImage;
import com.sprhibrad.framework.common.Utils;
import com.sprhibrad.framework.configuration.EntityRenderer;
import com.sprhibrad.framework.model.ShrEntity;
import com.sprhibrad.framework.tags.DataSetManager;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.springframework.format.annotation.DateTimeFormat;

public abstract class DataSetRenderer {
    protected DataSetManager tag;
    private String orderAttr;
    private String orientationAttr;
    String maleLiteral;
    String femaleLiteral;

    public DataSetRenderer(DataSetManager tag) {
        this.tag = tag;
        this.maleLiteral = tag.getMsgManager().msgOrKey("label.male");
        this.femaleLiteral = tag.getMsgManager().msgOrKey("label.female");
    }

    Format getFormat(String fieldName, ShrEntity object) {
        Format retVal = null;
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            if (Date.class.isAssignableFrom(field.getType())) {
                DateTimeFormat dateTimeFormatAnnotation = field.getAnnotation(DateTimeFormat.class);
                retVal = new Format(false);
                if (dateTimeFormatAnnotation != null) {
                    retVal.pattern = (String)Utils.annotationMethod((Annotation)dateTimeFormatAnnotation, "pattern");
                    retVal.style = (String)Utils.annotationMethod((Annotation)dateTimeFormatAnnotation, "style");
                }
            } else if (byte[].class.isAssignableFrom(field.getType())) {
                retVal = new Format(true);
            }
        }
        catch (IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
            e1.printStackTrace();
        }
        return retVal;
    }

    void render(boolean condition) {
        if (!condition) {
            return;
        }
        Vector<String> fieldsVector = new Vector<String>();
        Vector<String> headsVector = null;
        HashMap<String, String> ImagePreviewTargetMap = new HashMap<String, String>();
        String fieldName = null;
        Utils.comaSplitAndTrim(this.tag.getFields(), fieldsVector);
        int i = 1;
        while (i < fieldsVector.size()) {
            fieldName = fieldsVector.get(i);
            if (fieldName.charAt(0) == '[' && fieldName.charAt(fieldName.length() - 1) == ']') {
                ImagePreviewTargetMap.put(fieldsVector.get(i - 1), fieldName.substring(1, fieldName.length() - 1));
                fieldsVector.remove(i);
            }
            ++i;
        }
        if (this.tag.getHeads() == null) {
            headsVector = fieldsVector;
        } else {
            headsVector = new Vector();
            Utils.comaSplitAndTrim(this.tag.getHeads(), headsVector);
        }
        List detailObjects = (List)this.tag.request().getAttribute(this.getEntitysName());
        ShrEntity object = null;
        Object value = null;
        String inTbody = "";
        String inThead = "";
        HashMap<String, Format> formatMap = null;
        for (ShrEntity detailObject : detailObjects) {
            object = this.displayingObject(detailObject);
            inTbody = String.valueOf(inTbody) + "<tr>";
            value = null;
            if (formatMap == null) {
                formatMap = new HashMap<String, Format>();
                for (String fieldName2 : fieldsVector) {
                    formatMap.put(fieldName2, this.getFormat(fieldName2, object));
                }
                inThead = String.valueOf(inThead) + this.renderHeads(headsVector, formatMap);
            }
            for (String fieldName2 : fieldsVector) {
                fieldName2 = fieldName2.trim();
                value = Utils.extractValue(fieldName2, object);
                inTbody = String.valueOf(inTbody) + "<td>" + this.valueRender(fieldName2, value, formatMap, detailObject, object, ImagePreviewTargetMap) + "</td>";
            }
            value = Utils.extractValue("id", detailObject);
            inTbody = String.valueOf(inTbody) + Utils.cellWrap(this.renderRowCommand(value, detailObject));
            inTbody = String.valueOf(inTbody) + "</tr>";
        }
        if (inTbody.isEmpty()) {
            inTbody = this.tag.noRecords();
        }
        String html = "";
        html = String.valueOf(html) + "<table><tr><td class='label'>" + this.renderCaption() + "</td><td>" + this.renderAddCommand() + "</tr></table>";
        html = String.valueOf(html) + "<table class='mainList'>\t\t\t<thead>\r\n" + Utils.rowWrap(inThead) + "\t\t\t</thead>" + "\t\t\t<tbody>" + inTbody + "</tbody></table>";
        try {
            this.tag.out().println(html);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected ShrEntity displayingObject(ShrEntity detailObject) {
        return detailObject;
    }

    protected String renderCaption() {
        return "";
    }

    protected abstract String renderRowCommand(Object var1, ShrEntity var2);

    protected abstract String getEntitysName();

    protected abstract String getEntityName();

    protected abstract String getDisplayedEntity();

    protected String renderAddCommand() {
        return this.tag.renderAddCommand();
    }

    private String renderSortSymbol(HashMap<String, Integer> orderMap, String colName) {
        String symbol;
        Integer number = orderMap.get(colName);
        if (number == null) {
            return "";
        }
        if (number > 0) {
            symbol = "v";
        } else {
            symbol = "^";
            number = -number.intValue();
        }
        return "<b class='sortArrow'> " + symbol + " " + number + "</b>";
    }

    protected String renderHeads(Vector<String> headsVector, HashMap<String, Format> formatMap) {
        String html = "";
        Vector<String> fieldVector = new Vector<String>();
        Vector<String> orientationVector = new Vector<String>();
        Utils.comaSplitAndTrim(this.tag.getOrder(), fieldVector, this.tag.getOrientation(), orientationVector);
        int index = 0;
        HashMap<String, Integer> orderMap = new HashMap<String, Integer>();
        for (String field : fieldVector) {
            String gotOrientation = orientationVector.size() > index ? orientationVector.get(index) : "asc";
            orderMap.put(field, (gotOrientation.compareTo("asc") == 0 ? 1 : -1) * (index + 1));
            ++index;
        }
        String actionParamTheme = "orderCol=";
        String label = null;
        Format format = null;
        String targetMember = this.tag.request().getParameter("targetMember");
        String displayedEntity = this.getDisplayedEntity();
        for (String head : headsVector) {
            label = this.tag.getMsgManager().dictionary("attr." + (this.tag.getMsgManager().isClassSpecificDictionary(displayedEntity, head) ? String.valueOf(displayedEntity) + "." : "") + head);
            format = formatMap.get(head);
            html = String.valueOf(html) + "<th >" + (format != null && formatMap.get((Object)head).isAbinary ? label : String.valueOf(this.tag.targetCommand(label, this.target(), "btnaslnk", String.valueOf(actionParamTheme) + this.actionParamPrefix() + head + (targetMember == null ? "" : "&targetMember=" + targetMember))) + (orderMap.get(head) == null ? "" : this.renderSortSymbol(orderMap, head))) + "</th>";
        }
        html = String.valueOf(html) + "<th >" + (orderMap.size() == 0 ? "" : this.tag.targetCommand(this.tag.getMsgManager().msgOrKey("command.clearOrder"), this.target(), "reset", String.valueOf(actionParamTheme) + this.actionParamPrefix() + "_none")) + "</th>";
        return html;
    }

    protected abstract String actionParamPrefix();

    public String target() {
        return null;
    }

    private String sexRender(Object value) {
        return value.toString().equalsIgnoreCase("true") ? this.maleLiteral : this.femaleLiteral;
    }

    private String valueRender(String fieldName, Object value, HashMap<String, Format> formatMap, ShrEntity childObject, ShrEntity detailObject, HashMap<String, String> imagePreviewTargetMap) {
        if (value instanceof Date) {
            Format format = formatMap.get(fieldName);
            return this.tag.getDateFormatter().shrFormat(value, format.pattern, format.style);
        }
        if (value == null && formatMap != null && formatMap.get(fieldName) != null && formatMap.get((Object)fieldName).isAbinary || value instanceof byte[]) {
            return this.tag.imageTag(this.tag.getEntityName(), Utils.downCaseFirstChar(detailObject.getClass().getSimpleName()), detailObject.getId(), fieldName, imagePreviewTargetMap.get(fieldName), new ShrImage((byte[])value, fieldName, true).getFormatName());
        }
        if (value instanceof ShrEntity) {
            return new EntityRenderer(this.tag.getPageContext()).render((ShrEntity)value);
        }
        if (fieldName.compareTo("sex") == 0) {
            return this.sexRender(value);
        }
        return value == null ? "" : String.valueOf(value);
    }

    public void packOrder(String order, String orientation) {
        if (order != null) {
            try {
                this.tag.out().println("<table><tr><td>");
                this.tag.outHidden(String.valueOf(this.tag.orderParamPrefixName()) + "order", order);
                if (orientation != null) {
                    this.tag.outHidden(String.valueOf(this.tag.orderParamPrefixName()) + "orientation", orientation);
                }
                this.tag.out().println("</td></tr></table>");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void checkOrderAttrs() {
        this.orderAttr = (String)this.tag.request().getAttribute(String.valueOf(this.tag.orderParamPrefixName()) + "order");
        this.orientationAttr = (String)this.tag.request().getAttribute(String.valueOf(this.tag.orderParamPrefixName()) + "orientation");
    }

    public String getOrderAttr(String order) {
        this.checkOrderAttrs();
        return this.orderAttr == null ? order : this.orderAttr;
    }

    public String getOrientationAttr(String orientation) {
        return this.orientationAttr == null ? orientation : this.orientationAttr;
    }

    class Format {
        String style = "";
        String pattern = "";
        boolean isAbinary = false;

        public Format(boolean isAbinary) {
            this.isAbinary = isAbinary;
        }
    }
}

