/*
 * Decompiled with CFR 0.152.
 */
package com.sprhibrad.framework.tags;

import com.sprhibrad.framework.common.Utils;
import com.sprhibrad.framework.model.ShrEntity;
import com.sprhibrad.framework.tags.DataFormTag;
import com.sprhibrad.framework.tags.DataSetRenderer;
import com.sprhibrad.framework.tags.DetailsDataSetManager;
import com.sprhibrad.names.Names;

public class DetailSetRenderer
extends DataSetRenderer {
    private DetailsDataSetManager detailTag;

    public DetailSetRenderer(DetailsDataSetManager tag) {
        super(tag);
        this.detailTag = tag;
    }

    @Override
    protected String getEntitysName() {
        return Names.plural((String)this.getEntityName());
    }

    @Override
    protected String getEntityName() {
        return this.detailTag.getEntity();
    }

    @Override
    protected String renderRowCommand(Object object, ShrEntity detailObject) {
        return this.detailTag.detailRowCommand(this.detailTag.getEntity(), this.detailTag.getProperty(), String.valueOf(object), this.detailTag.getViewProperty(), this.detailTag.getNoDelete(), detailObject);
    }

    @Override
    protected String getDisplayedEntity() {
        return this.detailTag.getProperty() == null ? this.detailTag.getEntity() : Utils.downCaseFirstChar(this.getClassName(this.detailTag.getProperty()));
    }

    @Override
    protected String renderCaption() {
        return this.tag.getMsgManager().dictionary("entities." + Names.plural((String)this.getDisplayedEntity()));
    }

    private String getClassName(String property) {
        try {
            return this.tag.getMsgManager().getModelClass(this.detailTag.getEntity()).getDeclaredField(property).getType().getSimpleName();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected ShrEntity displayingObject(ShrEntity detailObject) {
        return this.detailTag.getProperty() == null ? detailObject : (ShrEntity)Utils.extractValue(this.detailTag.getProperty(), detailObject);
    }

    @Override
    protected String actionParamPrefix() {
        return String.valueOf(this.getEntitysName()) + "-";
    }

    @Override
    public String target() {
        return ((DataFormTag)this.detailTag.getFormTag()).getEntityId();
    }
}

