/*
 * Decompiled with CFR 0.152.
 */
package com.sprhibrad.framework.common;

import com.sprhibrad.framework.controller.ShrController;
import com.sprhibrad.framework.model.ShrEntity;
import com.sprhibrad.framework.tags.DataItem;
import com.sprhibrad.framework.tags.TermTag;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;

public class Utils {
    public static final String toParentFKslotPrefix = "SHR_ParentFK_";
    public static final String orderActionParam = "orderCol";
    public static final String operatorIdSuffix = "_SHRop";
    public static final String iterResult = "_iterResult";
    public static final String shrLocales = "shrLocales";
    public static final String propertiesPathExpr = "classpath:application.properties";
    public static final String shRepArgNull = "_SHR_NULL_";

    public static void outHidden(String name, String value, JspWriter out) {
        try {
            out.println(Utils.hidden(name, value));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String hidden(String name, String value) {
        return "<input type='hidden' " + Utils.idAndNameAttrs(name) + " value='" + value + "' />";
    }

    public static String idAndNameAttrs(String valueLiteral) {
        return String.valueOf(Utils.writeAttr("id", valueLiteral)) + Utils.writeAttr("name", valueLiteral);
    }

    public static String writeAttr(String attr, String valueLiteral) {
        return " " + attr + "='" + valueLiteral + "'";
    }

    public static String escape(String input) {
        return input.replace("'", "\\'");
    }

    public static Date getDateFromDbTimestamp(String input) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.S");
        return format.parse(input);
    }

    public static String downCaseFirstChar(String literal) {
        return String.valueOf(literal.substring(0, 1).toLowerCase()) + literal.substring(1);
    }

    public static String lowCaseName(Object obj) {
        return Utils.downCaseFirstChar(obj.getClass().getSimpleName());
    }

    public static String upCaseFirstChar(String literal) {
        return String.valueOf(literal.substring(0, 1).toUpperCase()) + literal.substring(1);
    }

    public static Boolean isEdit(ServletRequest servletRequest) {
        return Utils.isMode("edit", servletRequest);
    }

    public static Boolean isAdd(ServletRequest servletRequest) {
        return Utils.isMode("add", servletRequest);
    }

    public static Boolean isEditing(ServletRequest servletRequest) {
        if (!Utils.isAdd(servletRequest).booleanValue() && !Utils.isEdit(servletRequest).booleanValue()) {
            return false;
        }
        return true;
    }

    public static Boolean isMode(String modeName, ServletRequest servletRequest) {
        String mode = (String)servletRequest.getAttribute("mode");
        if (mode != null && mode.compareToIgnoreCase(modeName) == 0) {
            return true;
        }
        return false;
    }

    public static Boolean isAMultiModePage(ServletRequest servletRequest) {
        if (servletRequest.getAttribute("mode") != null) {
            return true;
        }
        return false;
    }

    public static Stack<ShrController.NavigatorNode> getNavigator(HttpServletRequest request) {
        return (Stack)request.getSession(false).getAttribute("navigator");
    }

    public static <T> Type[] typeArgumentClasses(Class<T> genericInstance) {
        return ((ParameterizedType)genericInstance.getGenericSuperclass()).getActualTypeArguments();
    }

    public static <T> Class typeArgumentClass(Class<T> genericInstance, int typeArgumentIndex) {
        return (Class)Utils.typeArgumentClasses(genericInstance)[typeArgumentIndex];
    }

    public static void comaSplitAndTrim(String sourceString, Vector<String> targetVector) {
        targetVector.removeAllElements();
        StringTokenizer tokenizer = new StringTokenizer(sourceString, ",");
        int tokenizerSize = tokenizer.countTokens();
        int i = 0;
        while (i < tokenizerSize) {
            targetVector.add(tokenizer.nextToken());
            ++i;
        }
        for (String string : targetVector) {
            string.trim();
        }
    }

    public static void comaSplitAndTrim(String sourceString1, Vector<String> targetVector1, String sourceString2, Vector<String> targetVector2) {
        Utils.comaSplitAndTrim(sourceString1, targetVector1);
        if (sourceString1 != null) {
            Utils.comaSplitAndTrim(sourceString2, targetVector2);
        }
    }

    public static void insideResize(Dimension constrainer, BufferedImage srcImg, Dimension outputDimension) {
        if (srcImg == null) {
            return;
        }
        boolean horizontalConstraint = (double)outputDimension.width / (double)outputDimension.height > constrainer.getWidth() / constrainer.getHeight();
        Utils.resize(outputDimension, horizontalConstraint ? constrainer.getWidth() / (double)outputDimension.width : constrainer.getHeight() / (double)outputDimension.height);
    }

    private static void resize(Dimension target, double factor) {
        target.height = (int)((double)target.height * factor);
        target.width = (int)((double)target.width * factor);
    }

    public static Object extractValue(String fieldName, ShrEntity object) {
        Method accessor = null;
        Object value = null;
        try {
            accessor = object.getClass().getDeclaredMethod(Utils.accessorName(false, fieldName), null);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        try {
            value = accessor.invoke((Object)object, null);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return value;
    }

    private static String accessorName(boolean set, String fieldName) {
        return String.valueOf(set ? "set" : "get") + Utils.upCaseFirstChar(fieldName);
    }

    public static void setValue(String fieldName, ShrEntity object, Object value) {
        Method accessor = null;
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            accessor = object.getClass().getDeclaredMethod(Utils.accessorName(true, fieldName), field.getType());
        }
        catch (NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        try {
            accessor.invoke((Object)object, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static String getImageKey(String user, String entityName, Serializable id, String imageField) {
        return String.valueOf(user) + "_" + entityName + "_" + id + "_" + imageField;
    }

    public static String cellWrap(String content) {
        return "<td>" + content + "</td>";
    }

    public static String rowWrap(String content) {
        return content.isEmpty() ? "" : "<tr>" + content + "</tr>";
    }

    public static boolean isContainerEditable(TermTag editableBox) {
        return !(editableBox instanceof DataItem) || ((DataItem)editableBox).getReadOnly() == false;
    }

    public static Boolean isADate(Object value) {
        if (!(value instanceof Timestamp) && !(value instanceof Date)) {
            return false;
        }
        return true;
    }

    public static Object annotationMethod(Annotation annotation, String methodName) {
        Object retVal = null;
        try {
            Method method = annotation.getClass().getDeclaredMethod(methodName, new Class[0]);
            retVal = method.invoke((Object)annotation, null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return retVal;
    }
}

