/*
 * Decompiled with CFR 0.152.
 */
package com.sprhibrad.framework.configuration;

import com.sprhibrad.framework.common.Utils;
import com.sprhibrad.framework.configuration.ShrCurrencyFormatter;
import com.sprhibrad.framework.configuration.ShrDateFormatter;
import com.sprhibrad.framework.model.ShrEntity;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.jsp.PageContext;
import org.springframework.format.annotation.NumberFormat;
import org.springframework.format.number.NumberStyleFormatter;
import org.springframework.format.number.PercentStyleFormatter;

public class EntityRenderer {
    PageContext pageContext;

    public EntityRenderer(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public String render(ShrEntity entity) {
        StringBuilder retVal = new StringBuilder("");
        Vector<String> verbosFields = null;
        if (entity != null) {
            verbosFields = entity.render();
        }
        boolean first = true;
        if (verbosFields == null) {
            retVal.append("- - -");
        } else {
            for (String fieldName : verbosFields) {
                if (!first) {
                    retVal.append(" ");
                }
                retVal.append(this.verboseFieldRendering(fieldName, entity));
                if (!first) continue;
                first = false;
            }
        }
        return retVal.toString();
    }

    private String verboseFieldRendering(String fieldName, ShrEntity entity) {
        Field field = null;
        try {
            field = entity.getClass().getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        Object fieldValue = Utils.extractValue(fieldName, entity);
        if (fieldValue == null) {
            return "";
        }
        ShrDateFormatter dateFormatter = (ShrDateFormatter)((Object)this.pageContext.getSession().getAttribute("dateFormatter"));
        if (fieldValue instanceof String) {
            return (String)fieldValue;
        }
        if (Utils.isADate(fieldValue).booleanValue()) {
            return dateFormatter.shrFormat(fieldValue);
        }
        if (fieldValue instanceof Number) {
            Locale locale = dateFormatter.getLocale();
            if (fieldValue instanceof BigDecimal) {
                return new ShrCurrencyFormatter().getNumberFormat(locale).format(fieldValue);
            }
            NumberFormat numberFormatAnnotation = field.getAnnotation(NumberFormat.class);
            boolean isPercent = false;
            if (numberFormatAnnotation != null) {
                NumberFormat.Style style = (NumberFormat.Style)Utils.annotationMethod((Annotation)numberFormatAnnotation, "style");
                boolean bl = isPercent = style == NumberFormat.Style.PERCENT;
            }
            if (isPercent) {
                return new PercentStyleFormatter().print((Number)fieldValue, locale);
            }
            return new NumberStyleFormatter().getNumberFormat(locale).format(fieldValue);
        }
        return String.valueOf(fieldValue == null ? "" : fieldValue);
    }
}

