/*
 * Decompiled with CFR 0.152.
 */
package com.sprhibrad.framework.configuration;

import com.sprhibrad.framework.configuration.ShrConfigurator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.springframework.format.datetime.DateFormatter;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.support.BindStatus;

@Component
public class ShrDateFormatter
extends DateFormatter {
    private Locale locale;
    private String pattern;
    private String stylePattern = new ShrConfigurator().getProperty("sprHibRad.dateStyle");

    public Locale getLocale() {
        return this.locale;
    }

    public ShrDateFormatter() {
        this.setStylePattern(this.stylePattern);
        this.setLenient(false);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.pattern = this.fourDigitsYearPattern(locale);
        this.setPattern(this.pattern);
    }

    public String shrFormat(BindStatus bindingStatus) {
        return this.stylePattern.length() == 0 ? bindingStatus.getDisplayValue() : this.shrFormat(bindingStatus.getActualValue());
    }

    public String shrFormat(Object actualvalue) {
        return this.shrFormat(actualvalue, "", "");
    }

    private String fourDigitsYearPattern(Locale locale) {
        String pattern = ((SimpleDateFormat)this.getDateFormat(locale)).toPattern();
        return pattern.indexOf("yy") == pattern.lastIndexOf("yy") ? pattern.replace("yy", "yyyy") : pattern;
    }

    public String shrFormat(Object actualvalue, String patternParm, String stylePatternParm) {
        if (stylePatternParm.length() > 0) {
            this.setStylePattern(stylePatternParm);
        }
        if (patternParm.length() > 0) {
            this.setPattern(patternParm);
        }
        String retVal = this.print((Date)actualvalue, this.locale);
        if (stylePatternParm.length() > 0) {
            this.setStylePattern(this.stylePattern);
        }
        if (patternParm.length() > 0) {
            this.setPattern(this.pattern);
        }
        return retVal;
    }

    public String toPattern() {
        return ((SimpleDateFormat)this.getDateFormat(this.locale)).toPattern();
    }

    public String print(Date date, Locale locale) {
        return super.print(date, this.locale);
    }

    public Date parse(String text, Locale locale) throws ParseException {
        this.setPattern(this.pattern);
        return super.parse(text, this.locale);
    }

    public String getPattern() {
        return this.pattern;
    }
}

