/*
 * Decompiled with CFR 0.152.
 */
package com.sprhibrad.framework.controller;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.env.Environment;
import org.springframework.web.servlet.view.AbstractView;

public abstract class ShrBirtView
extends AbstractView {
    @Resource
    private Environment env;
    protected HashMap<String, HashMap<String, Object>> reportParamsMap = new HashMap();

    public void render(Map<String, String> map, HttpServletRequest request, HttpServletResponse response, HashMap<String, Object> params) throws Exception {
        this.makeReportParamAvailable(request, map, params);
        this.render(map, request, response);
    }

    private void makeReportParamAvailable(HttpServletRequest request, Map<String, String> map, HashMap<String, Object> params) {
        String reportKey = this.getReportKey(request, map);
        this.reportParamsMap.put(reportKey, params);
    }

    public String getReportKey(HttpServletRequest request, Map<String, String> map) {
        return String.valueOf(request.getUserPrincipal().getName()) + "_" + this.shr_getName(map) + "_" + this.shr_getFormat(map);
    }

    protected void shr_setParameters(final Object task, HttpServletRequest request, Map<String, String> map) {
        HashMap<String, Object> params = this.reportParamsMap.remove(this.getReportKey(request, map));
        params.forEach(new BiConsumer<String, Object>(){

            @Override
            public void accept(String name, Object value) {
                ShrBirtView.this.shr_setParameter(task, name, String.valueOf(value).isEmpty() ? "_SHR_NULL_" : value);
            }
        });
    }

    protected String shr_getFormat(Map<String, String> map) {
        return map.get("format");
    }

    protected String shr_getName(Map<String, String> map) {
        return map.get("name");
    }

    protected String getReportsPath(Map map, HttpServletRequest request) {
        String langParameterizedReports = this.env.getProperty("sprHibRad.langParameterizedReports");
        HashMap<String, Object> params = this.reportParamsMap.get(this.getReportKey(request, map));
        String subPath = langParameterizedReports != null && langParameterizedReports.compareToIgnoreCase("true") == 0 ? "" : "/" + new Locale((String)params.get("loc_lang"), (String)params.get("loc_country")).toString();
        return "/reports" + subPath;
    }

    protected abstract void shr_setParameter(Object var1, String var2, Object var3);
}

