/*
 * Decompiled with CFR 0.152.
 */
package com.sprhibrad.framework.controller;

import com.sprhibrad.framework.common.DataSetClauses;
import com.sprhibrad.framework.common.ShrImage;
import com.sprhibrad.framework.common.Utils;
import com.sprhibrad.framework.configuration.ShrDateFormatter;
import com.sprhibrad.framework.configuration.ShrResourceBundleMessageSource;
import com.sprhibrad.framework.controller.BirtViewFactory;
import com.sprhibrad.framework.controller.ShrBindingErrorProcessor;
import com.sprhibrad.framework.controller.UserPreferences;
import com.sprhibrad.framework.model.ShrEntity;
import com.sprhibrad.framework.model.UserPrefs;
import com.sprhibrad.framework.model.UserTable;
import com.sprhibrad.framework.model.VerboseLiteral;
import com.sprhibrad.framework.service.IShrService;
import com.sprhibrad.names.Names;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.tika.Tika;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.validation.BindingErrorProcessor;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.servlet.view.UrlBasedViewResolver;

public abstract class ShrController<T extends ShrEntity> {
    private Stack<NavigatorNode> navigator;
    private HashMap<String, HashMap<String, ResultProperties>> resultsProperties;
    HashMap<String, byte[]> binariesMap = new HashMap();
    @Autowired
    protected IShrService<UserPrefs> userPrefsService;
    @Autowired
    protected LocaleResolver localeResolver;
    @Autowired
    FormattingConversionService conversionService;
    @Autowired
    ShrBindingErrorProcessor shBindingErrorProcessor;
    @Autowired
    UrlBasedViewResolver viewResolver;
    @Autowired
    BirtViewFactory birtViewFactory;
    @Autowired
    private PasswordEncoder passwordEncoder;
    private Locale.Builder localeBuilder;
    Vector<CriterionOperator> operators;
    @Resource
    private Environment env;

    public UserPreferences getUserPrefs(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        UserPrefs userPrefs = (UserPrefs)session.getAttribute("userPrefs");
        if (userPrefs == null) {
            String userName = request.getUserPrincipal().getName();
            userPrefs = this.userPrefsService.getObject((Serializable)((Object)userName));
            if (userPrefs == null) {
                userPrefs = new UserPrefs();
                userPrefs.setUser(userName);
                userPrefs.setHmenu(true);
                userPrefs.setLocale(Locale.getDefault().toString());
                this.userPrefsService.addObject(userPrefs);
            }
            this.setUserPrefs(request, response, userPrefs);
        }
        ShrResourceBundleMessageSource messageSource = (ShrResourceBundleMessageSource)((Object)session.getAttribute("messageSource"));
        this.localeResolver.setLocale(request, response, messageSource.getCurrentUserLocale());
        return new UserPreferences(userPrefs, messageSource, (ShrDateFormatter)((Object)session.getAttribute("dateFormatter")));
    }

    protected Locale.Builder getBuilder() {
        if (this.localeBuilder == null) {
            this.localeBuilder = new Locale.Builder();
        }
        return this.localeBuilder;
    }

    private Locale getUserLocale(UserPrefs userPrefs) {
        String userLocStr = userPrefs.getLocale();
        String userLanguage = userLocStr.substring(0, 2);
        String userRegion = userLocStr.length() == 5 ? userLocStr.substring(3) : null;
        return this.getBuilder().setLanguage(userLanguage).setRegion(userRegion).build();
    }

    public void setUserPrefs(HttpServletRequest request, HttpServletResponse response, UserPrefs userPrefs) {
        HttpSession session = request.getSession(false);
        session.setAttribute("userPrefs", (Object)userPrefs);
        Locale locale = this.getUserLocale(userPrefs);
        this.localeResolver.setLocale(request, response, locale);
        this.checkMessageSource(null, locale, session);
        this.checkMessageSource("dictionary", locale, session);
        ShrDateFormatter dateFormatter = (ShrDateFormatter)((Object)session.getAttribute("dateFormatter"));
        if (dateFormatter == null || dateFormatter.getLocale() != locale) {
            dateFormatter = new ShrDateFormatter();
        }
        dateFormatter.setLocale(locale);
        session.setAttribute("dateFormatter", (Object)dateFormatter);
    }

    void checkMessageSource(String baseName, Locale locale, HttpSession session) {
        String sessionParam = baseName == null ? "messageSource" : baseName;
        ShrResourceBundleMessageSource messageSource = (ShrResourceBundleMessageSource)((Object)session.getAttribute(sessionParam));
        if (messageSource == null) {
            messageSource = baseName == null ? new ShrResourceBundleMessageSource() : new ShrResourceBundleMessageSource(baseName);
        }
        messageSource.setCurrentUserLocale(locale);
        session.setAttribute(sessionParam, (Object)messageSource);
    }

    public HashMap<String, ResultProperties> getResultsProperties(String user) {
        if (this.resultsProperties == null) {
            this.resultsProperties = new HashMap();
        }
        if (this.resultsProperties.get(user) == null) {
            this.resultsProperties.put(user, new HashMap());
        }
        return this.resultsProperties.get(user);
    }

    Vector<CriterionOperator> getOperators() {
        if (this.operators == null) {
            this.operators = new Vector();
        }
        return this.operators;
    }

    public Stack<NavigatorNode> getNavigator(HttpServletRequest request) {
        this.navigator = (Stack)request.getSession(false).getAttribute("navigator");
        if (this.navigator == null) {
            this.navigator = new Stack();
            request.getSession(false).setAttribute("navigator", this.navigator);
        }
        return this.navigator;
    }

    public void pushNode(NavigatorNode node, HttpServletRequest request) {
        this.getNavigator(request).push(node);
    }

    public NavigatorNode popNode(HttpServletRequest request) {
        return this.getNavigator(request).pop();
    }

    public Object getObjectFromNode(NavigatorNode node) {
        return this.getObjectFromNode(node, node.entityName);
    }

    public Object getObjectFromNode(NavigatorNode node, String objName) {
        return node.attributes.get(objName);
    }

    public void putObjectIntoNode(NavigatorNode node, ShrEntity object) {
        this.putObjectIntoNode(node, node.entityName, object);
    }

    public void putObjectIntoNode(NavigatorNode node, String objName, Object object) {
        node.attributes.put(objName, object);
    }

    public NavigatorNode backTrackAndPeekNode(HttpServletRequest request) {
        NavigatorNode retVal = null;
        Stack<NavigatorNode> navigator = this.getNavigator(request);
        if (navigator.size() > 0) {
            int index = navigator.size() - 1;
            NavigatorNode node = null;
            do {
                node = (NavigatorNode)navigator.get(index);
                if (node.url.compareTo(request.getServletPath()) == 0) {
                    retVal = node;
                    continue;
                }
                --index;
            } while (retVal == null && index >= 0);
            if (retVal != null) {
                int index2 = navigator.size() - 1;
                while (index2 > index) {
                    navigator.pop();
                    --index2;
                }
            }
        }
        return retVal;
    }

    public ShrEntity getParentObjectFromNavigator(HttpServletRequest request, String entityName) {
        NavigatorNode node = null;
        Stack<NavigatorNode> navigator = this.getNavigator(request);
        ShrEntity object = null;
        if (navigator.size() >= 2) {
            int index = navigator.size();
            do {
                if ((node = (NavigatorNode)navigator.get(--index)) == null) continue;
                object = (ShrEntity)this.getObjectFromNode(node);
            } while (node != null && object != null && entityName.compareTo(node.entityName) == 0);
        }
        return object;
    }

    protected abstract IShrService<T> getService();

    protected abstract T getEntityInstance();

    protected String getEntityName() {
        return Utils.typeArgumentClass(this.getClass(), 0).getSimpleName();
    }

    protected String getEntityPropertyName() {
        return Utils.downCaseFirstChar(this.getEntityName());
    }

    protected String getEntitiesPropertyName() {
        return Names.plural((String)this.getEntityPropertyName());
    }

    protected String getEntityViewName() {
        return String.valueOf(this.getEntityPropertyName()) + "_form";
    }

    protected boolean validate(T object, BindingResult result) {
        return !result.hasErrors();
    }

    protected void setListFilter(T object, HttpServletRequest request) {
    }

    protected ResultProperties resultProperties(String user, String key) {
        if (key == null) {
            key = "_iterResult";
        }
        if (this.getResultsProperties(user).get(key) == null) {
            this.getResultsProperties(user).put(key, new ResultProperties());
        }
        return this.getResultsProperties(user).get(key);
    }

    public String orderAttr(String user, String key) {
        return this.resultProperties((String)user, (String)key).orderAttr;
    }

    public void setOrderAttr(String user, String key, String value) {
        this.resultProperties((String)user, (String)key).orderAttr = value;
    }

    public void appendOrderAttr(String user, String key, String value) {
        this.resultProperties((String)user, (String)key).orderAttr = String.valueOf(this.resultProperties((String)user, (String)key).orderAttr) + value;
    }

    public String orientationAttr(String user, String key) {
        return this.resultProperties((String)user, (String)key).orientationAttr;
    }

    public void setOrientationAttr(String user, String key, String value) {
        this.resultProperties((String)user, (String)key).orientationAttr = value;
    }

    public void appendOrientationAttr(String user, String key, String value) {
        this.resultProperties((String)user, (String)key).orientationAttr = String.valueOf(this.resultProperties((String)user, (String)key).orientationAttr) + value;
    }

    public DataSetClauses getClauses(String user, String key) {
        return this.resultProperties((String)user, (String)key).clauses;
    }

    NavigatorNode urlMatchingNode(HttpServletRequest request) {
        NavigatorNode node = this.peekNode(request);
        if (node != null && !node.obsolete) {
            node = this.backTrackAndPeekNode(request);
        }
        return node;
    }

    protected ShrEntity manageNode(Serializable id, HttpServletRequest request, String entityName, ModelAndView modelAndView, boolean forEdit, ShrEntity availableObject) {
        return this.manageNode(id, request, entityName, modelAndView, forEdit, null, null, null, availableObject);
    }

    protected ShrEntity manageNode(Serializable id, HttpServletRequest request, String entityName, ModelAndView modelAndView, boolean forEdit, Integer iteration, String listMode, T searchEntity, ShrEntity availableObject) {
        ShrEntity object;
        NavigatorNode node = this.urlMatchingNode(request);
        boolean obsoleteNode = node != null && node.obsolete;
        String url = null;
        String messageFromObsolete = null;
        if (obsoleteNode) {
            url = node.url;
            messageFromObsolete = node.message;
            this.popNode(request);
        }
        Object object2 = availableObject != null ? availableObject : (entityName == null ? null : (node == null || obsoleteNode ? (id == null ? this.getEntityInstance() : (ShrEntity)this.getService().getObject(id)) : (object = (ShrEntity)this.getObjectFromNode(node))));
        if (node == null || obsoleteNode) {
            node = new NavigatorNode(url == null ? request.getServletPath() : url, entityName);
            node.viewName = modelAndView.getViewName();
            if (messageFromObsolete != null) {
                node.message = messageFromObsolete;
            }
            node.isEdit = forEdit;
            if (object != null) {
                this.putObjectIntoNode(node, object);
                if (id != null) {
                    ShrEntity parentObject = this.getParentObjectFromNavigator(request, entityName);
                    Field[] fieldArray = object.getClass().getDeclaredFields();
                    int n = fieldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Field field = fieldArray[n2];
                        if (ShrEntity.class.isAssignableFrom(field.getType())) {
                            ShrEntity propertyObject = (ShrEntity)Utils.extractValue(field.getName(), object);
                            boolean storeInNode = true;
                            if (propertyObject != null) {
                                int propertyId = (Integer)propertyObject.getId();
                                if (parentObject != null) {
                                    int parentObjId = (Integer)parentObject.getId();
                                    if (field.getType() == parentObject.getClass() && propertyId == parentObjId) {
                                        storeInNode = false;
                                        this.putObjectIntoNode(node, "SHR_ParentFK_" + Names.plural((String)entityName), field.getName());
                                    }
                                }
                            }
                            if (storeInNode) {
                                this.putObjectIntoNode(node, field.getName(), propertyObject);
                            }
                        }
                        ++n2;
                    }
                }
            }
            if (searchEntity != null && iteration != null) {
                NavigatorNode currentTopNode = this.peekNode(request);
                if (iteration > 0 || iteration == 0 && currentTopNode.iteration != null && currentTopNode.iteration > 0) {
                    this.popNode(request);
                }
                node.iteration = iteration;
                node.listMode = listMode;
                node.entityName = Utils.lowCaseName(searchEntity);
                if (iteration > -1) {
                    this.putObjectIntoNode(node, (ShrEntity)searchEntity);
                }
            }
            this.pushNode(node, request);
        }
        modelAndView.addObject("message", (Object)node.message);
        node.message = "";
        return object;
    }

    public ModelAndView addObject(String viewName, String entityName, HttpServletRequest request, String fk) {
        ModelAndView modelAndView = new ModelAndView(viewName);
        ShrEntity object = this.manageNode(null, request, entityName, modelAndView, false, null);
        NavigatorNode node = this.peekNode(request);
        if (fk != null) {
            this.putObjectIntoNode(node, "SHR_ParentFK_" + Names.plural((String)entityName), fk);
        }
        modelAndView.addObject(entityName, (Object)object);
        modelAndView.addObject("mode", (Object)"add");
        return modelAndView;
    }

    protected String freezeObject(T object, HttpServletRequest request, String redir, String targetMember, String action) {
        NavigatorNode node = this.peekNode(request);
        if (node != null) {
            ShrEntity objectInNode = (ShrEntity)this.getObjectFromNode(node);
            Field[] fieldArray = object.getClass().getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!ShrEntity.class.isAssignableFrom(field.getType()) && field.getName().compareTo("id") != 0) {
                    Object propertyObject = Utils.extractValue(field.getName(), object);
                    this.setObjectMember(objectInNode, propertyObject, field.getName());
                }
                ++n2;
            }
        }
        return "redirect:/" + redir + "/" + action + "/-1.html" + "?targetMember=" + targetMember;
    }

    public MViewAndObj editObject(Serializable id, String viewName, String entityName, HttpServletRequest request) {
        return this.loadObject(true, id, viewName, entityName, request, null);
    }

    public MViewAndObj viewObject(Serializable id, String viewName, String entityName, HttpServletRequest request, String[] imageFields) {
        this.viewResolver.clearCache();
        MViewAndObj mavAndObj = this.loadObject(false, id, viewName, entityName, request, null);
        if (imageFields != null) {
            this.makeImagesAvailable(mavAndObj.obj, request, imageFields);
        }
        return mavAndObj;
    }

    public MViewAndObj loadObject(Boolean forEdit, Serializable id, String viewName, String entityName, HttpServletRequest request, ShrEntity availableObject) {
        ModelAndView modelAndView = new ModelAndView(viewName);
        ShrEntity object = this.manageNode(id, request, entityName, modelAndView, forEdit, availableObject);
        modelAndView.addObject(entityName, (Object)object);
        modelAndView.addObject("mode", (Object)(forEdit != false ? "edit" : "view"));
        return new MViewAndObj(modelAndView, object);
    }

    protected String getUser(HttpServletRequest request) {
        return request.getUserPrincipal().getName();
    }

    protected void addDetailsAttribute(String entitiesName, IShrService detailService, String property, T masterObject, ModelAndView modelAndView, HttpServletRequest request, String orders, String orientations, String detailFkMember, String[] previewFields) {
        this.checkOrderAttrs(request, entitiesName, orders, orientations);
        String user = this.getUser(request);
        request.setAttribute(String.valueOf(entitiesName) + "-order", (Object)this.orderAttr(user, entitiesName));
        request.setAttribute(String.valueOf(entitiesName) + "-orientation", (Object)this.orientationAttr(user, entitiesName));
        T entity = this.getEntityInstance();
        this.getClauses((String)user, (String)entitiesName).filter.clear();
        this.resultProperties(user, entitiesName).loadOrderClauses();
        this.resultProperties((String)user, (String)entitiesName).clauses.propertyToOrder = property;
        String fkMemberName = detailFkMember == null ? Utils.lowCaseName(masterObject) : detailFkMember;
        List objects = detailService.getDetailObjects(fkMemberName, (ShrEntity)masterObject, this.resultProperties((String)user, (String)entitiesName).clauses);
        if (previewFields != null) {
            for (ShrEntity object : objects) {
                this.makeImagesAvailable(property == null ? object : (ShrEntity)Utils.extractValue(property, object), request, previewFields);
            }
        }
        modelAndView.addObject("SHR_ParentFK_" + entitiesName, (Object)fkMemberName);
        modelAndView.addObject(entitiesName, objects);
    }

    protected ModelAndView redirectMavByNode(NavigatorNode node) {
        return this.redirectMavByNode(node, false);
    }

    protected ModelAndView redirectMavByNode(NavigatorNode node, boolean makeNodeObsolete) {
        if (makeNodeObsolete) {
            node.obsolete = true;
        }
        RedirectView redirectView = new RedirectView();
        redirectView.setContextRelative(true);
        redirectView.setUrl(node.url);
        ModelAndView mav = new ModelAndView();
        mav.setView((View)redirectView);
        return mav;
    }

    protected void addEditingAttributes(ModelAndView modelAndView, T obj) {
    }

    public ModelAndView saveObject(T object, String entityName, BindingResult result, HttpServletRequest request) {
        this.manageExtraViewAttr(object, this.peekNode(request), request, entityName);
        this.getService().addObject(object);
        this.popNode(request);
        this.prepareTopNode(request, entityName, "added");
        return this.redirectMavByNode(this.peekNode(request));
    }

    protected String cancel(HttpServletRequest request) {
        this.popNode(request);
        return this.goBackWithEffects(request, null, null);
    }

    public ModelAndView updateObject(T object, String entityName, BindingResult result, HttpServletRequest request) {
        this.manageExtraViewAttr(object, this.peekNode(request), request, entityName);
        this.getService().updateObject(object);
        this.popNode(request);
        this.peekNode((HttpServletRequest)request).obsolete = true;
        return this.redirectMavByNode(this.peekNode(request));
    }

    public ModelAndView renewModelAndView(HttpServletRequest request, String entityName, String effect, T object) {
        NavigatorNode node = this.peekNode(request);
        ModelAndView modelAndView = new ModelAndView(node.viewName);
        modelAndView.addObject(node.entityName == null ? entityName : node.entityName, object);
        modelAndView.addObject("mode", (Object)(effect.compareTo("stayAdd") == 0 ? "add" : "edit"));
        return modelAndView;
    }

    public String deleteObject(Integer id, String entityName, HttpServletRequest request) {
        this.getService().deleteObject(id);
        return this.goBackWithEffects(request, entityName, "deleted");
    }

    public String goBackWithEffects(HttpServletRequest request, String entityName, String effect) {
        NavigatorNode node = this.prepareTopNode(request, entityName, effect);
        return "redirect:" + (node == null ? "/index.html" : node.url);
    }

    public NavigatorNode prepareTopNode(HttpServletRequest request, String entityName, String effect) {
        NavigatorNode node = this.peekNode(request);
        if (effect == null) {
            node.message = "";
        } else {
            node.obsolete = effect.compareTo("updated") == 0;
            ShrResourceBundleMessageSource base = new ShrResourceBundleMessageSource();
            ShrResourceBundleMessageSource dictio = new ShrResourceBundleMessageSource("dictionary");
            String subject = dictio.msgOrKey("entity." + entityName);
            String action = base.msgOrKey("action." + effect);
            node.message = base.msgOrKey("message.success", new String[]{subject, action});
        }
        return node;
    }

    private void manageExtraViewAttr(T object, NavigatorNode node, HttpServletRequest request, String entityName) {
        String candidateMemberToParent;
        ShrEntity parentObjectCandidate = this.getParentObjectFromNavigator(request, entityName);
        if (parentObjectCandidate != null && (candidateMemberToParent = (String)this.getObjectFromNode(node, "SHR_ParentFK_" + Names.plural((String)entityName))) != null) {
            this.setObjectMember(object, parentObjectCandidate, candidateMemberToParent);
        }
        ShrEntity objectInNode = (ShrEntity)this.getObjectFromNode(node);
        Field[] fieldArray = object.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            ShrEntity propertyObject;
            Field field = fieldArray[n2];
            if (ShrEntity.class.isAssignableFrom(field.getType()) && !VerboseLiteral.class.isAssignableFrom(field.getType()) && (propertyObject = (ShrEntity)Utils.extractValue(field.getName(), objectInNode)) != null) {
                int propertyId = (Integer)propertyObject.getId();
                if (parentObjectCandidate == null || field.getType() != parentObjectCandidate.getClass() || propertyId != (Integer)parentObjectCandidate.getId()) {
                    this.setObjectMember(object, propertyObject, field.getName());
                }
            }
            ++n2;
        }
    }

    protected void setObjectMember(T object, Object sourceObject, String memberName) {
        Utils.setValue(memberName == null ? Utils.lowCaseName(sourceObject) : memberName, object, sourceObject);
    }

    protected ModelAndView objectList(Integer iteration, T object, BindingResult result, HttpServletRequest request, String[] imageFields) {
        return this.getList(new ListParams(this.getEntitiesPropertyName(), this.getEntitiesPropertyName(), iteration, request, imageFields, null), object, false, result);
    }

    public ModelAndView getList(ListParams listParams) {
        return this.getList(listParams, Integer.parseInt(this.env.getRequiredProperty("sprHibRad.pagesize")));
    }

    public ModelAndView getList(ListParams listParams, T searchEntity, boolean forSelection, BindingResult result) {
        HttpServletRequest request = listParams.request;
        NavigatorNode node = this.urlMatchingNode(request);
        Boolean backTracking = node != null && node.iteration > -1;
        this.checkOrderAttrs(request, null, null, null);
        if (backTracking.booleanValue()) {
            searchEntity = node.getObject();
            for (CriterionOperator op : this.getOperators()) {
                request.setAttribute(op.tagId, (Object)op.value);
            }
        }
        String user = this.getUser(request);
        request.setAttribute("_iterResult-order", (Object)this.orderAttr(user, null));
        request.setAttribute("_iterResult-orientation", (Object)this.orientationAttr(user, null));
        if (listParams.iteration > -1) {
            this.getClauses((String)user, null).filter.clear();
            this.getOperators().clear();
            this.setListFilter(searchEntity, request);
            this.resultProperties(user, null).loadOrderClauses();
        }
        String listMode = forSelection ? "choices" : "list";
        ModelAndView modelAndView = this.getList(listParams, searchEntity, Integer.parseInt(this.env.getRequiredProperty("sprHibRad.pagesize")), listMode, backTracking != false ? null : result);
        if (!backTracking.booleanValue()) {
            this.manageNode(null, request, null, modelAndView, false, listParams.iteration, listMode, searchEntity, null);
        }
        if (listParams.iteration == -1) {
            this.addEditingAttributes(modelAndView, searchEntity);
        }
        return modelAndView;
    }

    private void checkOrderAttrs(HttpServletRequest request, String nameParam, String orders, String orientations) {
        String orderCol;
        boolean isAnOrderCommadForThisList;
        String name = nameParam == null ? "_iterResult" : nameParam;
        String user = this.getUser(request);
        if (this.orderAttr(user, name) == null && orders != null) {
            this.setOrderAttr(user, name, orders);
            this.setOrientationAttr(user, name, orientations);
        }
        boolean bl = isAnOrderCommadForThisList = (orderCol = request.getParameter("orderCol")) != null && (nameParam == null || orderCol.indexOf(String.valueOf(nameParam) + "-") == 0);
        if (isAnOrderCommadForThisList && orderCol.compareTo(String.valueOf(name) + "-_none") == 0) {
            this.setOrderAttr(user, name, "");
            this.setOrientationAttr(user, name, "");
        } else {
            if (this.orderAttr(user, name) == null) {
                this.setOrderAttr(user, name, (String)request.getAttribute(String.valueOf(name) + "-order"));
            }
            if (this.orientationAttr(user, name) == null) {
                this.setOrientationAttr(user, name, (String)request.getAttribute(String.valueOf(name) + "-orientation"));
            }
            if (this.orderAttr(user, name) == null) {
                this.setOrderAttr(user, name, request.getParameter(String.valueOf(name) + "-order"));
            }
            if (this.orientationAttr(user, name) == null) {
                this.setOrientationAttr(user, name, request.getParameter(String.valueOf(name) + "-orientation"));
            }
            if (isAnOrderCommadForThisList) {
                Vector<String> orderVector = new Vector<String>();
                Vector<String> orientationVector = new Vector<String>();
                Utils.comaSplitAndTrim(this.orderAttr(user, name), orderVector, this.orientationAttr(user, name), orientationVector);
                int index = 0;
                String orientationItem = null;
                this.setOrientationAttr(user, name, "");
                boolean colOrderCHanged = false;
                String orderColField = orderCol.substring(name.length() + 1);
                for (String field : orderVector) {
                    if (orientationVector.size() > index) {
                        boolean preAsc = orientationVector.get(index).compareTo("asc") == 0;
                        boolean colOderIsToBeChanged = field.compareTo(orderColField) == 0;
                        String string = orientationItem = preAsc && !colOderIsToBeChanged || !preAsc && colOderIsToBeChanged ? "asc" : "desc";
                        if (!colOrderCHanged) {
                            colOrderCHanged = colOderIsToBeChanged;
                        }
                    } else {
                        orientationItem = "asc";
                    }
                    this.appendOrientationAttr(user, name, String.valueOf(index == 0 ? "" : ",") + orientationItem);
                    ++index;
                }
                if (!colOrderCHanged) {
                    this.appendOrderAttr(user, name, String.valueOf(index == 0 ? "" : ",") + orderColField);
                    this.appendOrientationAttr(user, name, String.valueOf(index == 0 ? "" : ",") + "asc");
                }
            }
        }
    }

    protected void addToFilter(String key, Object object, HttpServletRequest request) {
        String operatorTagId = String.valueOf(key) + "_SHRop";
        String operator = request.getParameter(operatorTagId);
        if (operator == null) {
            operator = (String)request.getAttribute(operatorTagId);
        }
        if (object != null || operator != null && (operator.compareTo("N") == 0 || operator.compareTo("NN") == 0)) {
            if (operator == null) {
                operator = "";
            }
            String user = this.getUser(request);
            this.getClauses(user, null).addCriterion(key, operator, object);
            this.getOperators().add(new CriterionOperator(operatorTagId, operator));
        }
    }

    public ModelAndView getList(ListParams listParams, Integer pageSize) {
        int gotSize;
        boolean furtherRecords;
        ModelAndView modelAndView = new ModelAndView(listParams.viewName);
        List<T> objects = this.getService().getObjects(listParams.iteration, this.getClauses(this.getUser(listParams.request), null), pageSize);
        if (listParams.imageFields != null) {
            for (ShrEntity object : objects) {
                this.makeImagesAvailable(object, listParams.request, listParams.imageFields);
            }
        }
        boolean bl = furtherRecords = (gotSize = objects.size()) == pageSize + 1;
        if (listParams.iteration != null) {
            modelAndView.addObject("more", (Object)(listParams.iteration >= 0 && furtherRecords ? 1 : 0));
        }
        if (furtherRecords) {
            objects.remove(gotSize - 1);
        }
        modelAndView.addObject(listParams.attributeName, objects);
        return modelAndView;
    }

    public ModelAndView getList(ListParams listParams, T searchEntity, Integer pageSize, String listMode, BindingResult result) {
        ModelAndView modelAndView;
        int iteration = listParams.iteration;
        Object searchEntityObject = null;
        boolean inputValidated = true;
        if (result != null) {
            boolean bl = inputValidated = iteration != 0 || this.validate(searchEntity, result);
        }
        if (iteration == -1 || !inputValidated) {
            modelAndView = new ModelAndView(listParams.viewName);
            if (iteration == -1) {
                searchEntityObject = this.getEntityInstance();
            }
            iteration = -1;
        } else {
            modelAndView = this.getList(listParams);
        }
        if (searchEntityObject == null) {
            searchEntityObject = searchEntity;
        }
        modelAndView.addObject(Utils.lowCaseName(searchEntityObject), searchEntityObject);
        modelAndView.addObject("iteration", (Object)iteration);
        modelAndView.addObject("listmode", (Object)listMode);
        modelAndView.addObject("initial", (Object)"empty");
        modelAndView.addObject("targetMember", (Object)listParams.targetMember);
        return modelAndView;
    }

    public NavigatorNode peekNode(HttpServletRequest request) {
        return this.peekNode(request, null);
    }

    public NavigatorNode peekNode(HttpServletRequest request, Integer backStep) {
        Stack<NavigatorNode> navigator = this.getNavigator(request);
        if (backStep == null) {
            return navigator.size() > 0 ? navigator.peek() : null;
        }
        return (NavigatorNode)navigator.get(navigator.size() - 1 - backStep);
    }

    protected String selectObject(Integer id, HttpServletRequest request, String member) {
        ShrEntity object = (ShrEntity)this.getService().getObject(id);
        NavigatorNode node = this.peekNode(request, 2);
        this.setObjectMember((ShrEntity)this.getObjectFromNode(node), object, member);
        return "redirect:" + node.url;
    }

    @ExceptionHandler
    public ModelAndView exceptionHandler(Exception exception) {
        exception.printStackTrace();
        LogManager.getLogger(this.getClass()).error(null, (Throwable)exception);
        ModelAndView modelAndView = new ModelAndView("exception");
        modelAndView.addObject("message", (Object)new ShrResourceBundleMessageSource().msgOrKey("exception.msg"));
        return modelAndView;
    }

    public byte[] getImage(String key, String ext) {
        return this.binariesMap.remove(String.valueOf(key) + "." + ext);
    }

    public String viewBinary(Integer id, String target, HttpServletRequest request, boolean isImage) {
        ShrEntity object = (ShrEntity)(id == null ? this.getObjectFromNode(this.peekNode(request)) : this.getService().getObject(id));
        String imageKey = this.makeBinaryAvailable(object, request, target, isImage);
        return "redirect:" + imageKey;
    }

    public ModelAndView uploadBinary(T object, String op, String pp, HttpServletRequest request) {
        ModelAndView modelAndView = new ModelAndView("uploadBinary");
        this.manageNode(null, request, null, modelAndView, false, null);
        modelAndView.addObject("op", (Object)op);
        String entityName = Utils.downCaseFirstChar(this.getEntityName());
        if (pp.length() > 0) {
            modelAndView.addObject("pp", (Object)pp);
            modelAndView.addObject("accept", (Object)"accept='.jpg,.jpeg,.png,.bmp,.gif'");
            modelAndView.addObject("entityName", (Object)entityName);
        }
        modelAndView.addObject("action", (Object)(String.valueOf(entityName) + "/doUploadBinary"));
        return modelAndView;
    }

    public ModelAndView deleteBinary(String op, String pp, HttpServletRequest request) {
        NavigatorNode node = this.peekNode(request);
        ShrEntity object = node.getObject();
        this.getService().deleteBinary(op, pp, object.getId());
        return this.redirectMavByNode(node, true);
    }

    public ModelAndView doUploadBinary(MultipartFile file, String op, String pp, HttpServletRequest request) {
        if (!file.isEmpty()) {
            byte[] bytes = null;
            try {
                bytes = file.getBytes();
                NavigatorNode node = this.peekNode(request, 1);
                ShrEntity object = node.getObject();
                this.getService().uploadBinary(bytes, op, pp, object.getId());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.popNode(request);
        return this.redirectMavByNode(this.peekNode(request), true);
    }

    public void checkPasswords(T object, BindingResult result, String oldPwd, String currPwd, String pwd2, HttpServletRequest request) {
        if (pwd2 != null && ((UserTable)object).getPassword().compareTo(pwd2) != 0) {
            result.rejectValue("password", "message.pwdsDontMatch");
        }
        if (!this.passwordEncoder.matches((CharSequence)oldPwd, currPwd)) {
            result.rejectValue("password", "message.wrongOldPwd");
        }
        int minPwdSize = Integer.parseInt(this.env.getRequiredProperty("sprHibRad.minPwdSize"));
        if (((UserTable)object).getPassword().length() < minPwdSize) {
            result.rejectValue("password", "message.tooShortPwd", (Object[])new String[]{String.valueOf(minPwdSize)}, null);
        }
        if (result.hasErrors()) {
            ((UserTable)object).setPassword(currPwd);
        } else {
            NavigatorNode node = this.peekNode(request, 1);
            ShrResourceBundleMessageSource messageSource = (ShrResourceBundleMessageSource)((Object)request.getSession().getAttribute("messageSource"));
            node.message = messageSource.msgOrKey("message.pwdChanged");
        }
    }

    private void makeImagesAvailable(ShrEntity object, HttpServletRequest request, String[] imageFields) {
        Field field = null;
        String[] stringArray = imageFields;
        int n = imageFields.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            try {
                field = object.getClass().getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException | SecurityException e1) {
                e1.printStackTrace();
            }
            if (field != null && field.getType() == byte[].class) {
                this.makeBinaryAvailable(object, request, field.getName(), true);
            }
            ++n2;
        }
    }

    private String makeBinaryAvailable(ShrEntity object, HttpServletRequest request, String imageField, boolean isImage) {
        String imageKey = null;
        try {
            Object value = Utils.extractValue(imageField, object);
            if (value != null) {
                String format;
                String string = format = isImage ? new ShrImage((byte[])value, imageField, true).getFormatName() : this.getFormatName((byte[])value);
                if (format != null) {
                    imageKey = String.valueOf(Utils.getImageKey(request.getUserPrincipal().getName(), Utils.downCaseFirstChar(this.getEntityName()), object.getId(), imageField)) + "." + format;
                    this.binariesMap.put(imageKey, (byte[])value);
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return imageKey;
    }

    protected void reportHandler(Map<String, String> map, HashMap<String, Object> params, HttpServletRequest request, HttpServletResponse response) {
        try {
            ShrResourceBundleMessageSource messageSource = (ShrResourceBundleMessageSource)((Object)request.getSession().getAttribute("messageSource"));
            Locale locale = messageSource.getCurrentUserLocale();
            params.put("loc_country", locale.getCountry());
            params.put("loc_lang", locale.getLanguage());
            this.birtViewFactory.create().render(map, request, response, params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getFormatName(byte[] value) {
        String contentType = new Tika().detect(value);
        return contentType.compareTo("text/plain") == 0 ? "txt" : contentType.substring(contentType.indexOf(47) + 1);
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.setBindingErrorProcessor((BindingErrorProcessor)this.shBindingErrorProcessor);
        this.shrInitBinder(binder);
    }

    protected void shrInitBinder(WebDataBinder binder) {
    }

    class CriterionOperator {
        String tagId;
        String value;

        public CriterionOperator(String tagId, String value) {
            this.tagId = tagId;
            this.value = value;
        }
    }

    class ListParams {
        String viewName;
        String attributeName;
        Integer iteration;
        HttpServletRequest request;
        String[] imageFields;
        String targetMember;

        public ListParams(String viewName, String attributeName, Integer iteration, HttpServletRequest request, String[] imageFields, String targetMember) {
            this.viewName = viewName;
            this.attributeName = attributeName;
            this.iteration = iteration;
            this.request = request;
            this.imageFields = imageFields;
            this.targetMember = targetMember;
        }
    }

    public class MViewAndObj {
        ModelAndView mav;
        ShrEntity obj;

        public MViewAndObj(ModelAndView mav, ShrEntity obj) {
            this.mav = mav;
            this.obj = obj;
        }
    }

    public class NavigatorNode {
        public String url;
        public Map<String, Object> attributes;
        public String entityName;
        public String message;
        public boolean obsolete;
        public String viewName;
        public Boolean isEdit;
        public Integer iteration;
        public Object listMode;

        public NavigatorNode(String url, String entityName) {
            this.url = url;
            this.entityName = entityName;
            this.attributes = new HashMap<String, Object>();
            this.obsolete = false;
        }

        public ShrEntity getObject() {
            return (ShrEntity)this.attributes.get(this.entityName);
        }
    }

    class ResultProperties {
        public DataSetClauses clauses = new DataSetClauses();
        public String orderAttr;
        public String orientationAttr;

        public void loadOrderClauses() {
            this.clauses.loadOrderClauses(this.orderAttr, this.orientationAttr);
        }
    }
}

