/*
 * Decompiled with CFR 0.152.
 */
package com.sprhibrad.framework.controller;

import com.sprhibrad.framework.configuration.ShrDateFormatter;
import com.sprhibrad.framework.configuration.ShrResourceBundleMessageSource;
import java.math.BigDecimal;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.TypeMismatchException;

public class ShrPropertyAccessException
extends PropertyAccessException {
    private ShrResourceBundleMessageSource messageSource;
    private ShrDateFormatter dateFormatter;
    private PropertyAccessException delegate;

    public ShrPropertyAccessException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public ShrPropertyAccessException(PropertyAccessException delegate, ShrResourceBundleMessageSource messageSource, ShrDateFormatter dateFormatter) {
        this(delegate.getMessage(), delegate.getCause());
        this.delegate = delegate;
        this.messageSource = messageSource;
        this.dateFormatter = dateFormatter;
    }

    public String getErrorCode() {
        return this.delegate.getErrorCode();
    }

    public String getPropertyName() {
        return this.delegate.getPropertyName();
    }

    public Object getValue() {
        return this.delegate.getValue();
    }

    public String getLocalizedMessage() {
        String msg = null;
        if (this.getErrorCode().compareTo("typeMismatch") == 0) {
            msg = this.getCause() instanceof NumberFormatException ? this.messageSource.msgOrKey(((TypeMismatchException)this.delegate).getRequiredType() == BigDecimal.class ? "valid.bigDecimal" : "valid.number", new Object[]{this.getValue()}) : this.messageSource.msgOrKey("valid.date", new Object[]{this.getValue(), this.dateFormatter.toPattern()});
        }
        return msg;
    }
}

