/*
 * Decompiled with CFR 0.152.
 */
package com.sprhibrad.framework.tags;

import com.sprhibrad.framework.common.ShrImage;
import com.sprhibrad.framework.common.Utils;
import com.sprhibrad.framework.tags.BinaryItem;
import com.sprhibrad.framework.tags.DataItem;
import com.sprhibrad.framework.tags.ShrBinaryTag;
import com.sprhibrad.framework.tags.TermTag;

public class ImageTag
extends ShrBinaryTag {
    String previewPath;
    String width;
    String height;

    @Override
    String getArguments() {
        return String.valueOf(super.getArguments()) + this.previewPath;
    }

    @Override
    protected String getObjectPath() {
        return this.previewPath;
    }

    @Override
    String rendering() {
        String format = new ShrImage(this.getBytes(), this.previewPath, true).getFormatName();
        return Utils.cellWrap(this.imageTag(this.getEntityName(), null, this.getEntityObj().getId(), this.previewPath, this.path, format, this.width, this.height, true));
    }

    public String getPreviewPath() {
        return this.previewPath;
    }

    public void setPreviewPath(String previewPath) {
        this.previewPath = previewPath;
    }

    @Override
    protected void checkFurtherInheritance(TermTag editableBox) {
        String tagPath = this.getPreviewPath();
        if ((tagPath == null || tagPath.isEmpty()) && editableBox instanceof DataItem) {
            this.setPreviewPath(((BinaryItem)editableBox).getPreviewPath());
        }
        super.checkFurtherInheritance(editableBox);
    }

    @Override
    void reset() {
        super.reset();
        this.previewPath = null;
        this.width = null;
        this.height = null;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    @Override
    String getVerbose() {
        return "image";
    }
}

