/*
 * Decompiled with CFR 0.152.
 */
package com.sprhibrad.framework.tags;

import com.sprhibrad.framework.common.Utils;
import com.sprhibrad.framework.configuration.EntityRenderer;
import com.sprhibrad.framework.configuration.MenuConfig;
import com.sprhibrad.framework.controller.ShrController;
import com.sprhibrad.framework.model.ShrEntity;
import com.sprhibrad.framework.model.UserPrefs;
import com.sprhibrad.framework.tags.ShrFormTag;
import com.sprhibrad.names.Names;
import java.io.IOException;
import java.util.Stack;
import javax.servlet.ServletContext;

public class NavigFormTag
extends ShrFormTag {
    private String caption;
    private String innerCaption;

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getInnerCaption() {
        return this.innerCaption;
    }

    public void setInnerCaption(String innerCaption) {
        this.innerCaption = innerCaption;
    }

    public Boolean getHmenu() {
        UserPrefs userPrefs = (UserPrefs)this.pageContext.getSession().getAttribute("userPrefs");
        return userPrefs == null ? true : userPrefs.getHmenu();
    }

    @Override
    protected String outsidePreRenderedHtml() {
        String entityName = this.extractModelAttribute();
        String defaultEntity = Utils.escape(this.msgMgr().msgOrKey("entity." + Utils.upCaseFirstChar(entityName)));
        String targetMember = (String)this.request().getAttribute("targetMember");
        String scriptTag = "<script type='text/javascript' >function add() { redir('add', 0); }function list(iter) { redir('list', iter); }function choices(iter)  { redir('choices', iter); }function view(id) { redir('view', id); }function select(id) { redir('select', id); }function del(id, renderedEntity) { redir('del', id, renderedEntity); }function redir(action, identifier, renderedEntity, entityName, entityPath) {\tvar doIt = true;\tif (action == 'delete') {\t\tvar entityTarget = entityName == null ? '" + defaultEntity + "' : entityName;" + "\t\tvar verboseTarget = renderedEntity == null ? '" + this.msgMgr().msgOrKey("question.delWhat") + "'.replace('{0}', entityTarget) : renderedEntity;" + "\t\tvar msg = '" + this.msgMgr().msgOrKey("question.deleteFrom") + "'.replace('{0}', verboseTarget);" + "\t\tdoIt = confirm(msg);" + "\t}" + "\tvar url = '" + this.contextPathTheme() + "' + (entityPath == null ? '" + entityName + "' : entityPath) + '/' + action + " + "\t\t\t\t(identifier == 0 ? '' : ('/' + identifier + '.html')) + '" + (targetMember == null ? "" : "?targetMember=" + targetMember) + "';" + "\tif (doIt)" + "\t\tlocation.href = url;" + "}" + "</script>";
        return String.valueOf(this.heading()) + "<body onload=\"javascript:{" + this.jsOnLoad() + "}\" >" + scriptTag + (this.caption == null ? "" : "<h1>" + this.msgMgr().msgOrKey(this.caption, new Object[]{this.appName()}) + "</h1>");
    }

    protected String jsOnLoad() {
        return this.getHmenu() != false ? "" : "var elem = document.getElementById('menu'); elem.scrollTop=(elem.scrollHeight - elem.clientHeight);";
    }

    @Override
    protected String caption() {
        return this.caption;
    }

    @Override
    protected String builtTitle() {
        String retVal = null;
        if (this.innerCaption == null) {
            String modelAttribute = this.extractModelAttribute();
            retVal = modelAttribute.compareTo("command") == 0 ? "" : this.msgMgr().dictionary("entities." + Names.plural((String)modelAttribute));
        } else {
            String target = this.request().getParameter("op");
            String entityName = (String)this.request().getAttribute("entityName");
            String qualifier = this.msgMgr().isClassSpecificDictionary(entityName, target) ? String.valueOf(entityName) + "." : "";
            retVal = this.msgMgr().msgOrKey(this.innerCaption, new Object[]{this.msgMgr().dictionary("attr." + qualifier + target)});
        }
        return retVal;
    }

    @Override
    protected String insidePreRenderedHtml() {
        return "<div class='container'><div class='" + this.hmenuDependentClass("menu") + "' id='menu'>" + this.navigator() + "</div>" + "<div class='" + this.hmenuDependentClass("page") + "'>" + "<h1>" + this.builtTitle() + "</h1>";
    }

    @Override
    protected String postRenderedHtml() {
        return "</div></div>";
    }

    private String hmenuDependentClass(String className) {
        return this.getHmenu() != false ? className : String.valueOf(className) + "2";
    }

    private String navigator() {
        Stack<ShrController.NavigatorNode> navigator = Utils.getNavigator(this.request());
        String retVal = "<table>";
        if (navigator == null || navigator.size() == 1) {
            retVal = String.valueOf(retVal) + this.getMenu();
        } else {
            String itemSet = "";
            int index = 0;
            ShrController.NavigatorNode node = null;
            while (index < navigator.size() - 1) {
                node = (ShrController.NavigatorNode)navigator.get(index);
                if (node.iteration == null && (!((ShrController.NavigatorNode)navigator.get((int)(index + 1))).isEdit.booleanValue() || index == 0 && ((ShrController.NavigatorNode)navigator.get((int)(index + 1))).url.compareTo("/changePwd") == 0) || node.iteration != null && node.iteration == -1 && navigator.size() - index > 2 && ((ShrController.NavigatorNode)navigator.get((int)(index + 2))).iteration == null) {
                    itemSet = String.valueOf(itemSet) + this.navItem(node);
                }
                ++index;
            }
            retVal = String.valueOf(retVal) + (this.getHmenu() != false ? Utils.rowWrap(itemSet) : itemSet);
        }
        retVal = String.valueOf(retVal) + "</table>";
        return retVal;
    }

    private String navItem(ShrController.NavigatorNode node) {
        ShrEntity entity = node.getObject();
        String retVal = "<td class='" + this.hmenuDependentClass("navItem1") + "'>";
        if (entity != null) {
            retVal = String.valueOf(retVal) + this.msgMgr().messageSource().getMessage("entity." + entity.getClass().getSimpleName(), null, "", null);
        }
        retVal = String.valueOf(retVal) + "</td><td class='" + this.hmenuDependentClass("navItem2") + "'>";
        retVal = String.valueOf(retVal) + "<a href='" + this.request().getContextPath() + node.url + "'>" + (entity == null ? (node.entityName == null ? this.msgMgr().msgOrKey("view." + node.viewName) : this.msgMgr().dictionary("entities." + Names.plural((String)node.entityName))) : (entity.render() == null || entity.render().size() == 0 ? this.msgMgr().dictionary("entity." + node.entityName) : new EntityRenderer(this.pageContext).render(entity))) + "</a>";
        retVal = String.valueOf(retVal) + "</td>";
        return this.getHmenu() != false ? retVal : Utils.rowWrap(retVal);
    }

    private void write(String text) {
        try {
            this.pageContext.getOut().append((CharSequence)text);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String menuItem(String path, String label, String postQuestion) {
        String url = String.valueOf(this.request().getContextPath()) + path;
        String retVal = "<td class='" + this.hmenuDependentClass("menuItem") + "'><a href=\"" + (postQuestion == null ? url : "javascript:askAndPost('" + postQuestion + "','shr','" + url + "');") + "\">" + label + "</a></td>  ";
        return this.getHmenu() != false ? retVal : Utils.rowWrap(retVal);
    }

    private String entityMenuItem(String entityOrPath) {
        boolean directPage = entityOrPath.charAt(0) == '/';
        String entity = directPage ? entityOrPath.substring(1) : entityOrPath;
        return this.menuItem("/" + entity + (directPage ? "" : "/list/-1.html"), this.msgMgr().dictionary(directPage ? "entity." + entity : "entities." + Names.plural((String)entity)), null);
    }

    private String getMenu() {
        ServletContext context = this.pageContext.getServletContext();
        MenuConfig menuConfig = (MenuConfig)context.getAttribute("menu");
        String retVal = "";
        for (MenuConfig.Item item : menuConfig.items) {
            retVal = String.valueOf(retVal) + (item.labelOrKey == null ? this.entityMenuItem(item.entityOrPath) : this.menuItem(item.entityOrPath, this.msgMgr().msgOrKey(item.labelOrKey), null));
        }
        retVal = ((String)context.getAttribute("userprefsmenu")).compareTo("true") == 0 ? String.valueOf(retVal) + this.menuItem("/userPrefs", this.msgMgr().msgOrKey("menu.userPrefs"), null) : String.valueOf(retVal) + this.menuItem("/changePwd", this.msgMgr().msgOrKey("menu.changePwd"), null);
        retVal = String.valueOf(retVal) + this.menuItem("/logout", this.msgMgr().msgOrKey("menu.logout"), this.msgMgr().msgOrKey("question.logout"));
        return this.getHmenu() != false ? Utils.rowWrap(retVal) : retVal;
    }
}

