/*
 * Decompiled with CFR 0.152.
 */
package com.sprhibrad.framework.tags;

import com.sprhibrad.framework.common.Utils;
import com.sprhibrad.framework.configuration.EntityRenderer;
import com.sprhibrad.framework.model.ShrEntity;
import com.sprhibrad.framework.tags.MessageManager;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.springframework.web.util.HtmlUtils;

public class ShrTagSupport
extends TagSupport {
    private String value;
    private String msgKey;
    MessageManager msgManager = new MessageManager();

    MessageManager msgMgr() {
        this.msgManager.setPageContext(this.pageContext);
        return this.msgManager;
    }

    public String wantToDelQuestion(String whatKey) {
        String verboseTarget = this.msgMgr().msgOrKey("question.delWhat", new String[]{whatKey == null ? this.msgMgr().msgOrKey("enitity.item") : this.msgMgr().msgOrKey(whatKey)});
        return this.msgMgr().msgOrKey("question.delete", new String[]{verboseTarget});
    }

    public HttpServletRequest request() {
        return (HttpServletRequest)this.pageContext.getRequest();
    }

    protected String contextPath() {
        return this.pageContext.getServletContext().getContextPath();
    }

    public JspWriter out() {
        return this.pageContext.getOut();
    }

    protected Boolean isEdit() {
        return Utils.isEdit((ServletRequest)this.request());
    }

    protected Boolean isAdd() {
        return Utils.isAdd((ServletRequest)this.request());
    }

    protected String optionTag(String currentVal, String value, String content) {
        return "<option " + (currentVal != null && currentVal.compareTo(value) == 0 ? "selected='selected'" : "") + "value='" + value + "'>" + HtmlUtils.htmlEscape((String)content) + "</option>";
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getMsgKey() {
        return this.msgKey;
    }

    public void setMsgKey(String msgKey) {
        this.msgKey = msgKey;
    }

    protected void outHref(String subPath, String literal, String entityName, String id) throws IOException {
        this.out().println(this.href(subPath, literal, entityName, id));
    }

    protected String href(String subPath, String literal, String entityName, String id) {
        return this.href(subPath, literal, entityName, id, null, null);
    }

    protected String href(String subPath, String literal, String entityName, String identifier, ShrEntity entity, String verboseEntityName) {
        String langEntity = null;
        langEntity = entityName == null ? null : Utils.escape(this.msgMgr().msgOrKey("entity." + Utils.upCaseFirstChar(verboseEntityName == null ? entityName : verboseEntityName)));
        String href = this.getUrl(subPath, identifier, entity, langEntity, entityName);
        String label = literal == null ? this.msgMgr().msgOrKey(subPath) : literal;
        return "<a href=\"" + href + "\">" + label + "</a>";
    }

    protected String getUrl(String subPath, String identifier, ShrEntity entity, String entityName, String entityPath) {
        boolean defaultEntity = entityName == null;
        return "javascript:redir('" + subPath + "'," + (identifier == null ? Integer.valueOf(0) : identifier) + (entity == null ? (defaultEntity ? "" : ",null") : ",'" + this.renderEntity(entity) + "'") + (defaultEntity ? "" : ",'" + entityName + "','" + entityPath + "'") + ");";
    }

    protected String renderEntity(ShrEntity entity) {
        return new EntityRenderer(this.pageContext).render(entity);
    }

    public static String renderEntity(ShrEntity entity, PageContext pageContext) {
        return String.valueOf(new EntityRenderer(pageContext).render(entity)) + (Utils.isAMultiModePage(pageContext.getRequest()) != false ? "" : " <<<<<< SprHibRAD: Usage not allowed: make the entity of the atribute used as search criterium to be an instance of the VerboseLiteral class or remove the criterium from the search box ! >>>>>>>");
    }

    public void outHidden(String name, String value) throws IOException {
        Utils.outHidden(name, value, this.out());
    }

    protected String inputTag(String caption, String actionAttr, String cssClass) {
        String cssClassAttr = cssClass == null ? "" : "class='" + cssClass + "'";
        return "<input " + cssClassAttr + " value='" + caption + "' type='submit'" + actionAttr + " />";
    }

    protected String inputTag(String caption, String actionTheme, String action, String cssClass, String confirmMsg) {
        return this.inputTag(caption, actionTheme, action, cssClass, null, confirmMsg);
    }

    protected String inputTag(String caption, String actionTheme, String action, String cssClass, String actionParams, String confirmMsg) {
        StringBuilder actionAttr = new StringBuilder("");
        if (action != null) {
            actionAttr.append(" formaction=\"");
            String url = String.valueOf(actionTheme) + action + (actionParams == null ? "" : "?" + actionParams);
            actionAttr.append(confirmMsg == null ? url : "javascript:askAct('" + confirmMsg + "','" + url + "');");
            actionAttr.append("\"");
        }
        return this.inputTag(caption, actionAttr.toString(), cssClass);
    }

    protected void outButton(String caption, String actionTheme, String action, String confirmMsg, String cssClass) throws IOException {
        this.outInputTag(caption, actionTheme, action, true, confirmMsg, cssClass);
    }

    protected void outInputTag(String caption, String actionTheme, String action, boolean cellWrap, String confirmMsg, String cssClass) throws IOException {
        String tag = this.inputTag(caption, actionTheme, action, cssClass, confirmMsg);
        this.out().println(cellWrap ? Utils.cellWrap(tag) : tag);
    }

    public String styleWrap(String content, String cssClass) {
        return "<b class='" + cssClass + "'>" + content + "</b>";
    }

    protected String getText() {
        return this.msgMgr().msgOrKey(this.getMsgKey());
    }

    public String detailRowCommand(String entityName, String detailProperty, String id, Boolean viewProperty, String noDelete, ShrEntity childObject) {
        String html = "";
        ShrEntity detailObject = detailProperty == null ? childObject : (ShrEntity)Utils.extractValue(detailProperty, childObject);
        String viewId = viewProperty != false ? String.valueOf(detailObject.getId()) : id;
        String childEntityName = Utils.lowCaseName(childObject);
        String detailEntityName = Utils.lowCaseName(detailObject);
        String viewEntityName = viewProperty != false ? detailEntityName : childEntityName;
        html = String.valueOf(html) + this.styleWrap(this.href("view", this.msgMgr().msgOrKey("command.view"), viewEntityName, viewId, null, entityName), "linkWrap");
        if (noDelete == null || noDelete.compareTo("true") != 0) {
            html = String.valueOf(html) + this.styleWrap(this.href("delete", this.msgMgr().msgOrKey("command.delete"), childEntityName, id, childObject, entityName), "linkWrap");
        }
        return html;
    }

    public String imageTag(String entityName, String targetImageEntity, Serializable id, String fieldName, String targetImageField, String format) {
        return this.imageTag(entityName, targetImageEntity, id, fieldName, targetImageField, format, null, null, false);
    }

    public String imageTag(String previewManagerEntity, String targetImageEntity, Serializable id, String fieldName, String targetImageField, String format, String width, String height, boolean fromObjectView) {
        String prefixForTarget;
        StringBuilder labString = new StringBuilder("");
        String prefixForPreview = prefixForTarget = String.valueOf(this.contextPath()) + "/";
        if (format != null) {
            prefixForTarget = String.valueOf(prefixForTarget) + (targetImageEntity == null ? previewManagerEntity : targetImageEntity) + "/";
            prefixForPreview = String.valueOf(prefixForPreview) + previewManagerEntity + "/";
        }
        if (targetImageField != null && format != null) {
            labString.append("<a href='" + prefixForTarget + "viewImage?target=" + targetImageField);
            labString.append("&id=" + (fromObjectView ? "" : id));
            labString.append("' target='_blank'>");
        }
        String source = format == null ? "noImg.jpg" : String.valueOf(Utils.getImageKey(this.request().getUserPrincipal().getName(), previewManagerEntity, id, fieldName)) + "." + format;
        labString.append("<img src='" + prefixForPreview + source + "'" + this.attribute("width", width) + this.attribute("height", height) + " />");
        if (targetImageField != null && format != null) {
            labString.append("</a>");
        }
        return labString.toString();
    }

    String attribute(String name, String value) {
        return value == null ? "" : String.valueOf(name) + "='" + value + "' ";
    }
}

